/** \class "Sort"

La clase "Sort" implementa la interfaz \See"Filter" y usa el algoritmo
Quick Sort sobre "String"s. Modifica las reglas normales de manera que
`del a' queda detrs de `de lo'. Adems ignora los caracteres
`{\tt\char92}' y `{\tt\char34}'. De este modo produce el mismo resultado
que el programa C correspondiente al generar los ndices de ``El
problema aparente''\footnote{Ramn Casares:
 {\sl El problema aparente. Una teora del conocimiento},
 {\sc Visor} Dis., Madrid, 1999. {\sc Isbn}: 84-7774-877-2.}.

Ha sido adaptada de Sun QSortAlgorithm v. 1.6 96/12/06

@author  Ramn Casares 2000
@version 2000.05.02
*/
package TexFiles;

import java.util.Locale;
import java.text.Collator;
import java.text.CollationKey;
import java.text.RuleBasedCollator;

public class Sort implements Filter {

 /** \constructor "Sort()" */
 public Sort() {}

 /** \constructor "Sort(String, String)"

 Crea un objeto "Sort" y
 ordena el fichero "infile" y lo salva como "outfile".

 @param infile el fichero a leer para ordenar
 @param outfile el fichero ordenado a escribir
 */
 public Sort(String infile, String outfile)
  throws java.io.IOException { execute(infile, outfile); }

 /** \method "execute(String, String)"

 Ordena el fichero "infile" y lo salva como "outfile".
 Con este mtodo implementa la interfaz \See"Filter".

 @param infile el fichero a leer para ordenar
 @param outfile el fichero ordenado a escribir
 @exception java.io.IOException si hay un error al leer o escribir
 */
 public void execute(String infile, String outfile)
  throws java.io.IOException {
  try {
   CharFile in = new CharFile(infile);
   RuleBasedCollator esCollator =
    (RuleBasedCollator) Collator.getInstance(new Locale("es","ES"));
   String texRules = esCollator.getRules()
    + "&'_'=' '&'_'='}'" // treat space and } as _
    + "&\u0000='\\'&\u0000='\"'"; // ignore \ and "
   RuleBasedCollator texCollator = new RuleBasedCollator(texRules);
   CollationKey[] keys = new CollationKey[in.line.length];
   for (int i=0; i<in.line.length; i++)
    keys[i] = texCollator.getCollationKey(in.line[i]);
   sort(keys);
   for (int i=0; i<in.line.length; i++)
    in.line[i] = keys[i].getSourceString();
   in.store(outfile);
  } catch (Exception e) { System.out.println(e); }
 }

 /** \method "QuickSort(CollationKey[], int, int)"

  Esta es una versin genrica del algoritmo Quicksort de
  C.A.R Hoare\footnote{C.A.R. Hoare: {\sl Quicksort} (1962).
   Reimpreso en {\sl Great Papers in Computer Science},
    editado por Ph. Laplante,
   IEEE Press, Piscataway NJ \& West, St. Paul MN; 1996.
   {\sc Isbn}: 0-7803-1112-4.}.
  Es capaz de tratar "array"s ya ordenados y "array"s con claves duplicadas.
  Usa el mtodo auxiliar "swap".

  @param a       el array a ordenar
  @param lo0     lmite inferior
  @param hi0     lmite superior
  @exception Exception si algo va mal
  */
 static void QuickSort(CollationKey a[], int lo0, int hi0)
  throws Exception {

  int lo = lo0;
  int hi = hi0;
  CollationKey mid;

  if ( hi0 > lo0) {
   mid = a[ ( lo0 + hi0 ) / 2 ];
   while( lo <= hi ) {
    while( ( lo < hi0 ) && ( a[lo].compareTo(mid) < 0 ) ) ++lo;
    while( ( hi > lo0 ) && ( a[hi].compareTo(mid) > 0 ) ) --hi;
    if( lo <= hi ) swap(a, lo++, hi--);
   }
   if( lo0 < hi ) QuickSort( a, lo0, hi );
   if( lo < hi0 ) QuickSort( a, lo, hi0 );
  }
 }

 private static void swap(CollationKey a[], int i, int j)
  {  CollationKey T; T = a[i]; a[i] = a[j]; a[j] = T;  }


 /** \method "sort(CollationKey[])"

 Llama al algoritmo Quick Sort inicializando los parmetros.

 @param a es el array a ordenar
 */
 public static void sort(CollationKey[] a) throws Exception
  {  QuickSort(a, 0, a.length - 1);  }

 /** \method "main(String[])"

  La presente implementacin del mtodo principal ("main") permite hacer
  dos usos directos de la clase "Sort".
  Si se le llama sin argumentos, por ejemplo pinchando el fichero
  "Sort.class", entonces se ejecuta dentro de la ventana grfica
  proporcionada por la clase \See"FilterW".
  Si se le llama con dos argumentos, entonces ordena las lneas del
  fichero cuyo nombre figura como primer argumento y deja el resultado
  en un fichero cuyo nombre es el segundo argumento.
  En cualquier otro caso muestra la sintaxis de llamada de esta clase.

  @param args son los argumentos de la lnea de comandos
  */
 public static void main(String[] args) {
  if (args.length == 2) {
   try { new Sort(args[0],args[1]); }
   catch (java.io.IOException e) { System.out.println(e); }
  } else if (args.length == 0) {
   new FilterW("Sort",new Sort(),"","");
  } else {
   System.out.println("Syntax: Sort [<input filename> <output filename>]");
  }
 }

}
