/** \class "Regex"

 Implements a regular expressions processor.

@author  Ramn Casares 2003
@version 2003.11.03
*/
package TexFiles;

import java.util.regex.Pattern;
import java.util.regex.Matcher;
import javax.swing.JOptionPane;

public class Regex implements Filter {

 /**\variable"p" is the current pattern */
 public Pattern p;
 public String sp;

 /**\variable"r" is the replacement */
 public String r;

 /**\method"newPattern(String)" */
 public Pattern newPattern(String regex) {
  p = Pattern.compile(regex);
  sp = new String(regex);
  return(p);
 }

 public Pattern newPattern() {
  String regex = JOptionPane.showInputDialog(null,"New Pattern:",sp);
  if( regex != null ) {
   p = Pattern.compile(regex);
   sp = new String(regex);
  }
  return(p);
 }

 /**\method"newReplacement(String)" */
 public String newReplacement(String rep) {
  r = new String(rep);
  return(r);
 }

 public String newReplacement() {
  String rep = JOptionPane.showInputDialog(null,"New Replacement for "+sp,r);
  if( rep != null ) r = new String(rep);
  return(r);
 }


 /**\method"newPattern(String, String)" */
 public Pattern newPattern(String regex, String rep) {
  p = Pattern.compile(regex);
  sp = new String(regex);
  r = new String(rep);
  return(p);
 }

 /**\method"verboseExecute(String)" */
 public String verboseExecute(String text) {
  if( p == null || text == null ) return("");
  Matcher m = p.matcher(text);
  StringBuffer sb = new StringBuffer();
  while (m.find()) m.appendReplacement(sb, r);
  m.appendTail(sb);
  return( sb.toString() );
 }

 public String execute(String text) {
  return( text.replaceAll(sp,r) );
 }

 public void execute(String filein, String fileout)
  throws java.io.IOException {
  CharFile cf = new CharFile(filein);
  for(int i=0; i<cf.line.length; i++)
   if(cf.line[i] != null)
    cf.line[i] = verboseExecute(cf.line[i]);
  cf.store(fileout);
 }


}
