/** \class "FilterW"

Proporciona una GUI (Interfaz Grfica de Usuario) a las clases que
implementan la interfaz \See"Filter" o a aquellos programas externos que
aceptan la sintaxis "progname infile outfile".

Por su parte, "FilterW" implementa las interfaces "ActionListener" y
"WindowListener".

Al arrancar "FilterW" aparece la ventana principal \See"FilterW#w". Para
seleccionar el fichero desde el que se leen los datos se puede pulsar el
botn "Search in", y entonces aparece la ventana de entrada
\See"FilterW#wi". Del mismo modo, pero apretando el botn "Search out",
se puede seleccionar el fichero en el que se escribir el resultado de
aplicar el filtro. Las acciones que resultan de pulsar los botones de la
ventana principal \See"FilterW#w" estn especificadas en el mtodo
\See"FilterW#actionPerformed(ActionEvent)".

@author  Ramn Casares 2000
@version 2000.05.02
@see Filter
*/
package TexFiles;

import java.awt.*;
import java.awt.event.*;

public class FilterW
 implements ActionListener, WindowListener {

 /** \variable "w"  (ventana principal)  */
 private Window w;
 /** \variable "wi" (ventana de entrada) */
 private Window wi;
 /** \variable "wo" (ventana de salida)  */
 private Window wo;

 /** \variable "namein" (contiene el nombre del fichero de entrada) */
 private TextField namein;
 /** \variable "nameout" (contiene el nombre del fichero de salida) */
 private TextField nameout;

 /** \variable "activefilter" (contiene el valor del filtro activo) */
 private Label activefilter;

 /** \variable "filter" (objeto que implementa la interfaz \See"Filter") */
 private Filter filter = null; // null si usa un programa externo

 private Regex re = new Regex();

 /** \variable "progname" (nombre del programa externo) */
 private String progname = "xcopy /i ";

 /** \constructor "FilterW()" */
 public FilterW() {}

 /** \constructor "FilterW(String, Filter, String, String)"

 Crea un objeto "FilterW" que trabaja sobre un objeto Java que
 implementa la interfaz \See"Filter".

 @param title ttulo que aparece en la ventana
 @param filter objeto Java que determina la accin a ejecutar
 @param infile fichero del que se lee
 @param outfile fichero en el que se escribe
 @see Filter
 */
 public FilterW(String title, Filter filter,
  String infile, String outfile) {
  this.filter = filter;
  this.progname = title;
  openW(title, infile, outfile);
 }

 /** \constructor "FilterW(String, String, String, String)"

 Crea un objeto "FilterW" que trabaja sobre un programa externo que
 acepta la sintaxis "progname infile outfile".

 @param title ttulo que aparece en la ventana
 @param progname programa externo que determina la accin a ejecutar
 @param infile fichero del que se lee
 @param outfile fichero en el que se escribe
 */
 public FilterW(String title, String progname,
  String infile, String outfile) {
  this.filter = null;
  this.progname = progname;
  openW(title, infile, outfile);
 }

 /** \method "openW(String, String, String)"

 Crea la ventana principal, \See"FilterW#w".
 Es un panel de dos filas,
 1) una para el fichero de entrada y
 2) otra para el  de salida,
 y cuatro columnas,
 1) una etiqueta que explica de que fichero se trata, entrada o salida,
 2) un cuadro para introducir el nombre del fichero,
 3) un botn de bsqueda, que crea una ventana de bsqueda de ficheros, y
 4) un botn para ejecutar el filtro o cancelarlo todo.

 @param title ttulo que aparece en la ventana
 @param infile fichero del que se lee
 @param outfile fichero en el que se escribe
 */
 public void openW(String title, String infile, String outfile) {
  Frame f = new Frame(title); w = f;
  f.setBackground(Color.lightGray);
  // f.setForeground(Color.black);

  MenuBar bar = new MenuBar(); /////////////////////////////////
   Menu mFile = new Menu("File");
    MenuItem miClose = new MenuItem("Close");
     miClose.addActionListener(this);
     mFile.add(miClose);
   bar.add(mFile);

   Menu mFilter = new Menu("Filters");
    MenuItem miCopy = new MenuItem("Copy");
     miCopy.addActionListener(this);
     mFilter.add(miCopy);
    MenuItem miReplace = new MenuItem("Replace");
     miReplace.addActionListener(this);
     mFilter.add(miReplace);
    MenuItem miSort = new MenuItem("Sort");
     miSort.addActionListener(this);
     mFilter.add(miSort);
   bar.add(mFilter);

   Menu mHelp = new Menu("Help");
    MenuItem miAbout = new MenuItem("About TexFiles");
     miAbout.addActionListener(this);
     mHelp.add(miAbout);
   bar.add(mHelp);

  f.setMenuBar(bar);

  ////////////////////////////////////////////////////////////////

  GridBagLayout gridbag = new GridBagLayout();
  GridBagConstraints c = new GridBagConstraints();
  // setFont(new Font("Helvetica", Font.PLAIN, 14));
  f.setLayout(gridbag);

  Label textin = new Label("Input file:",Label.RIGHT);
  namein = new TextField(infile,25);
  Label textout = new Label("Output file:",Label.RIGHT);
  nameout = new TextField(outfile,25);

  Button searchin = new Button("Search in");
  Button searchout = new Button("Search out");

  //Button cancel = new Button("Cancel");
  activefilter = new Label("Copy",Label.CENTER);
  Button execute = new Button("Execute");

  searchin.addActionListener(this);
  execute.addActionListener(this);
  searchout.addActionListener(this);
  //cancel.addActionListener(this);

  c.fill = GridBagConstraints.BOTH; // for all
  c.gridheight = 1; c.weighty = 0.0; // for all
  c.insets = new Insets(5,5,5,5);
  c.gridwidth = 1; c.weightx = 0.0; // not expandable
  gridbag.setConstraints(textin, c); f.add(textin);
  c.gridwidth = 3; c.weightx = 1.0; // expandable
  gridbag.setConstraints(namein, c); f.add(namein);
  c.gridwidth = GridBagConstraints.RELATIVE; //last but one
  c.weightx = 0.0; // not expandable
  gridbag.setConstraints(searchin, c); f.add(searchin);
  c.gridwidth = GridBagConstraints.REMAINDER; //end row
  //gridbag.setConstraints(cancel, c); f.add(cancel);
  gridbag.setConstraints(activefilter, c); f.add(activefilter);
  c.gridwidth = 1;
  gridbag.setConstraints(textout, c); f.add(textout);
  c.gridwidth = 3; c.weightx = 1.0; // expandable
  gridbag.setConstraints(nameout, c); f.add(nameout);
  c.gridwidth = GridBagConstraints.RELATIVE; //last but one
  c.gridwidth = 1; c.weightx = 0.0; // not expandable
  gridbag.setConstraints(searchout, c); f.add(searchout);
  c.gridwidth = GridBagConstraints.REMAINDER; //end row
  gridbag.setConstraints(execute, c); f.add(execute);

  f.pack(); f.setSize(f.getPreferredSize()); f.show();

  f.addNotify();
  f.addWindowListener(this);

  }

 /** \method "takeinputname()"

 Crea la ventana de entrada para seleccionar el fichero de entrada,
 \See"FilterW#wi".
 El fichero elegido, cuyo nombre completo (con path) devuelve
 este mtodo, es el que ser ledo.

 La ventana \See"FilterW#wi" tiene vida fuera de este mtodo,
 y as puede ser vista por el "WindowListener".

 @return el nombre del fichero elegido para leer
 */
 private String takeinputname() {
  Frame fi = new Frame("Input file"); wi = fi;
  FileDialog fdi = new FileDialog(fi,"Input name",FileDialog.LOAD);
  fdi.pack(); fdi.show(); fdi.addNotify();
  fdi.addWindowListener(this);
  return(fdi.getDirectory() + fdi.getFile());
 }

 /** \method "takeoutputname()"

 Crea la ventana de salida para seleccionar el fichero de salida,
 \See"FilterW#wo".
 El fichero elegido, cuyo nombre completo (con path) devuelve
 este mtodo, es el que ser escrito.

 La ventana \See"FilterW#wo" tiene vida fuera de este mtodo,
 y as puede ser vista por el "WindowListener".

 @return el nombre del fichero elegido para leer
 */
 private String takeoutputname() {
  Frame fo = new Frame("Output file"); wo = fo;
  FileDialog fdo = new FileDialog(fo,"Output name",FileDialog.SAVE);
  fdo.pack(); fdo.show(); fdo.addNotify();
  fdo.addWindowListener(this);
  return(fdo.getDirectory() + fdo.getFile());
 }

 /** \method "actionPerformed(ActionEvent)"

 Este es el nico mtodo definido en la interfaz "ActionListener",
 que as queda implementada.
 La implementacin determina que accin se ejecuta al pulsar
 cada uno de los botones definidos en la ventana principal,
 \See"FilterW#w".

 @param e es la accin ejecutada
 */
 public void actionPerformed(ActionEvent e) {
  String texto = e.getActionCommand();
  if ("Close".equals(texto)) System.exit(0);
  if ("Cancel".equals(texto)) System.exit(0);
  if ("Execute".equals(texto)) {
   try {
    if (filter==null) {
     String commandstring = progname+" \""+
      namein.getText() + "\" \"" + nameout.getText() + "\"";
     Runtime.getRuntime().exec(commandstring);
     System.out.println("Executed: " + commandstring);
    } else {
     filter.execute(namein.getText(),nameout.getText());
     System.out.println("Executed: " + progname +
      "(" + namein.getText() + "," + nameout.getText() + ");");
    }
   } catch (java.io.IOException ioe) { System.out.println(ioe); }
  }
  if ("Copy".equals(texto)) {
   filter = null;
   progname = "xcopy /i ";
   activefilter.setText("Copy");
  }
  if ("Sort".equals(texto)) {
   filter = new Sort();
   progname = "Sort";
   activefilter.setText("Sort");
  }
  if ("Replace".equals(texto)) {
   re.newPattern();
   re.newReplacement();
   filter = re;
   progname = "Replace";
   activefilter.setText("Replace");
  }
  if ("Search in".equals(texto)) {
   String niaux = this.takeinputname();
   if (!"nullnull".equals(niaux)) namein.setText(niaux);
   w.show(); }
  if ("Search out".equals(texto)) {
   String noaux = this.takeoutputname();
   if (!"nullnull".equals(noaux)) nameout.setText(noaux);
   w.show(); }
  if ("About TexFiles".equals(texto)) {
   String[] message = new String[3];
   message[0] = "TexFiles version 1.0";
   message[1] = " 2004 Ramn Casares";
   message[2] = "r.casares@ieee.org";
   javax.swing.JOptionPane.showMessageDialog(null,message,
    "About TeXFiles",javax.swing.JOptionPane.INFORMATION_MESSAGE);
  }
 }

 /** \method "windowClosing(WindowEvent)"

 El nico mtodo no vaco de la interfaz "WindowListener".
 Debe distinguir en cul de las ventanas se ejecuta la accin.
 Al cerrarse la ventana principal, \See"FilterW#w",
 se termina el programa.

 La implementacin de los otros mtodos de la interfaz
 "WindowListener" est vaca.

 @param e es la accin ejecutada en la ventana
 */
 public void windowClosing(WindowEvent e) {
  if(e.getWindow() == w) { w.dispose(); System.exit(0);}
  if(e.getWindow() == wi) { wi.dispose(); }
  if(e.getWindow() == wo) { wo.dispose(); }
 }
 public void windowOpened(WindowEvent e) {}
 public void windowClosed(WindowEvent e) {}
 public void windowIconified(WindowEvent e) {}
 public void windowDeiconified(WindowEvent e) {}
 public void windowActivated(WindowEvent e) {}
 public void windowDeactivated(WindowEvent e) {}

 /** \method "main(String[])"

 Ejecuta la ventana grfica tomando los nombres de los ficheros,
 si los hay, de la lnea de comandos. Si hay uno, supone que es el
 del fichero a leer. Si hay dos, el primero es el de lectura,
 el segundo el de escritura. Si son ms, se ignoran del tercero
 en adelante.

 Como usa el constructor nulo, \See"FilterW#FilterW()", se aplica el
 programa externo definido por defecto, "xcopy /i", lo que quiere decir
 que, si el sistema operativo es DOS, copia el fichero de entrada en el
 de salida.

 @param args los argumentos de la lnea de comandos
 */
 public static void main(String[] args) {
  FilterW fw = new FilterW();
  if (args.length == 0) fw.openW("Filter","","");
  if (args.length == 1) fw.openW("Filter",args[0],"");
  if (args.length  > 1) fw.openW("Filter",args[0],args[1]);
  }

}
