/** \class "CharFile"

La clase "CharFile" permite traer a memoria ("load") un fichero de
texto, almacenndolo como un array de "String"s de nombre "line". Este
array es accesible ("public"), por lo que puede manipularse de cualquier
modo que se quiera. Tambin permite salvar ("store") en un fichero de
texto el contenido, modificado o no, de "line". Adems, incluye mtodos
que permiten hacer sustituciones mltiples. Si se utiliza por s misma,
la clase "CharFile" copia un fichero de texto pudiendo hacer mltiples
sustituciones (vase \See"CharFile#main(String[])").

@author  Ramn Casares 2000
@version 2000.05.02
*/
package TexFiles;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Vector;

public class CharFile {

 /** \variable "filename"

 El nombre del fichero a leer. Por defecto es "delete.txt".
 */
 String filename = "delete.txt";

 /** \variable "line"

 Un array de "String"s en donde se almacena el contenido del fichero.
 */
 public String[] line = null;

 /** \constructor "Charfile()"

 Usa los valores por defecto.
 */
 public CharFile() { }

 /** \constructor "Charfile(String)"

 Construye el objeto y carga "line" con el contenido del fichero
 cuyo nombre toma como parmetro.

 @param filename es el nombre del fichero
 */
 public CharFile(String filename) throws java.io.IOException {
  this.filename = filename; this.load(); }

 /** \method "load(String)"

 Carga en memoria el contenido del fichero cuyo nombre es el
 parmetro pasado.

 @param filename nombre del fichero que se trae a memoria
 @return el contenido del fichero
 @exception java.io.IOException si falla la lectura del fichero
 */
 public String[] load(String filename) throws java.io.IOException {
  this.filename = filename;
  return(load());
 }

 /** \method "load()"

 Carga en memoria el contenido del fichero cuyo nombre guarda
 la variable "filename"; por defecto "delete.txt".

 @return el contenido del fichero
 @exception java.io.IOException si falla la lectura del fichero
 */
 public String[] load() throws java.io.IOException {
  this.line = null;
  Vector inbuffer = new Vector();
  BufferedReader in = new BufferedReader(new FileReader(filename));
  String newline = in.readLine();
  while (newline != null) {
   inbuffer.addElement(newline);
   newline = in.readLine();
  }
  in.close();
  this.line = new String[inbuffer.size()];
  for (int i=0; i<this.line.length; i++) {
   this.line[i] = (String)inbuffer.elementAt(i);
  }
  return(this.line);
 }

 /** \method "store(String)"

 Actualiza el valor de la variable "filename" y
 salva en el fichero "filename" el contenido de la variable "contents".

 @param filename es el nombre del fichero
 @exception java.io.IOException si hay problemas para escribir el fichero
 */
 public void store(String filename) throws java.io.IOException {
  this.filename = filename;
  store();
 }

 /** \method "store()"

 Salva en el fichero cuyo nombre contiene la variable "filename"
 el contenido de la variable "contents".
 Los otros mtodos "store" terminan llamando a ste.

 @exception java.io.IOException si hay problemas para escribir el fichero
 */
 public void store() throws java.io.IOException {
  BufferedWriter out = new BufferedWriter(new FileWriter(filename));
  for (int i=0; i<line.length; i++) { out.write(line[i]); out.newLine(); }
  out.close();
 }

 /** \method "append(String, String)"

 Aade a cada "String" de "line" el "String" "pre" al comienzo y
 el "String" "post" al final.

 @param pre se aade al comienzo de cada lnea
 @param post se aade al final de cada lnea
 */
 public void append(String pre, String post) {
  for (int l=0; l<line.length; l++) { line[l] = pre + line[l] + post; }
 }

 /** \method "delimite(String)"

 Cambia la forma de "line" poniendo los fines de lnea en donde
 encuentra el "String" "del".

 @param del marca dnde se hacen las divisiones de lnea
 */
 public void delimite(String del) {
  String[] nline = new String[count(del)+1]; int nl = 0;
  for (int l=0; l<nline.length; l++) { nline[l] = ""; }
  for (int l=0; l<line.length; l++) { int i = 0;  int j;
   while ( i < line[l].length() ) { j = line[l].indexOf(del,i);
    if ( j == -1 ) {
     nline[nl] = nline[nl] + line[l].substring(i);
     i = line[l].length();
    } else {
     nline[nl] = nline[nl] + line[l].substring(i,j);
     nl++;
     i = j + del.length();
  }}}
  line = nline;
 }

 /** \method "count(String, String)"

 Cuenta el nmero de veces que el "String" "so"
 ocurre en el "String" "s".

 @param so es el "String" a contar
 @param s es el "String" donde se hace la cuenta
 @return el nmero de veces
 */
 public static int count(String so, String s) {
  int c = 0;  int i = 0;  int j;
  while ( i < s.length() ) { j = s.indexOf(so,i);
   if ( j == -1 ) { i = s.length(); }
   else { c++; i = j + so.length(); }
  }
  return c;
 }

 /** \method "count(String)"

 Cuenta el nmero de veces que el "String" "so" ocurre en "line".

 @param so es el "String" a contar
 @return el nmero de veces
 */
 public int count(String so) {
  int c = 0;
  for(int l=0; l<line.length; l++) { c = c + count(so,line[l]); }
  return c;
 }

 /** \method "replace(String, String, String)"

 Reemplaza en el "String" "s" cada ocurrencia del "String" "olds" por
 el "String" "news".

 @param olds es el "String" a sustituir
 @param news es el "String" por el que se sustituye
 @param s es el "String" donde se hace la sustitucin
 @return el resultado de hacer la sustitucin
 */
 public static String replace(String olds, String news, String s) {
  String t = "";  int i = 0;  int j;
  while ( i < s.length() ) { j = s.indexOf(olds,i);
   if ( j == -1 ) { t = t + s.substring(i); i = s.length(); }
   else { t = t + s.substring(i,j) + news; i = j + olds.length(); }
  }
  return t;
 }

 /** \method "replace(String[], String[])"

 Reemplaza en "line" cada ocurrencia
 de los "String"s del array "olds[]"
 por los correspondientes "String"s del array "news[]".

 @param olds es el array de "String"s a sustituir
 @param news es el array con los "String"s que sustituyen
 */
 public void replace(String[] olds, String[] news) {
  for ( int l = 0; l < line.length; l++)
   for ( int j = 0; (j < olds.length) && (j < news.length); j++)
    line[l] = replace(olds[j],news[j],line[l]);
 }

 /** \method "main(String[])"

 Los argumentos pueden ser cuatro, tres o dos.

 Si se llama con cuatro argumentos, entonces cada uno contiene
 el nombre de un fichero.
 El primero contiene en cada lnea un "String" cuya aparicin
 ha de ser sustituida por el "String" que ocupa la misma lnea
 en el segundo fichero. El tercer fichero es el que se lee y
 el cuarto es en el que se escribe el resultado de la
 sustitucin mltiple efectuada.

 As, los ficheros "TeXcode.txt" y "Wincode.txt" permiten traducir
 ficheros codificados en ASCII, con las convenciones de \TeX, en ANSI,
 que es la codificacin utilizada por Windows, y viceversa.
 Por ejemplo:
 \smallskip
 "java TeXFilter TeXcode.txt Wincode.txt TeXfile WinFile"
 \smallbreak
 hace una rplica del fichero "TeXFile" de nombre "WinFile"
 pero, por ejemplo, donde aparece "\'a" en "TeXFile" escribe "" en
 "WinFile", mientras que:
 \smallskip
 "java TeXFilter Wincode.txt TeXcode.txt Winfile TeXFile"
 \smallbreak
 hace lo inverso, es decir, replica el fichero "WinFile" en el
 fichero "TeXFile", pero, por ejemplo, donde aparece "" en "WinFile"
 escribe "\'a" en "TeXFile".

 Se listan los ficheros "TeXcode.txt" y "Wincode.txt":
 \doublecolumns
 {\bf TeXcode.txt}\smallskip
 {\catcode`\"=12\listing{TeXcode.txt}}\bigbreak
 {\bf Wincode.txt}\smallskip
 \listing{Wincode.txt}
 \singlecolumn

 Si se llama con tres argumentos, entonces
 el primero es el "String" delimitador,
 el segundo el archivo a leer y
 el tercero el archivo a escribir.

 Si se llama con dos argumentos, entonces copia le fichero cuyo nombre
 es el primer argumento en un fichero de nombre el pasado como segundo
 argumento.

 Si no son dos, tres o cuatro, muestra el uso autnomo de esta clase.

 @param args son los argumentos de la lnea de comandos
 */
 public static void main(String[] args) {
  if (args.length == 4) {
   try {
    CharFile oldf = new CharFile(args[0]);
    CharFile newf = new CharFile(args[1]);
    CharFile af = new CharFile(args[2]);
    af.replace(oldf.line,newf.line);
    af.store(args[3]);
   } catch (java.io.IOException e) { System.out.println(e); }
  } else if (args.length == 3) {
   try {
    CharFile in = new CharFile(args[1]);
    in.delimite(args[0]);
    in.store(args[2]);
   } catch (java.io.IOException e) { System.out.println(e); }
  } else if (args.length == 2) {
   try {
    CharFile in = new CharFile(args[0]);
    in.store(args[1]);
   } catch (java.io.IOException e) { System.out.println(e); }
  } else {
   System.out.println("Syntax: TeXFilter [ <old> <new> ] <base> <mod>");
   System.out.println("   <old>:  file with substrings to replace from");
   System.out.println("   <new>:  file with substrings to replace with");
   System.out.println("   <base>: file to modify");
   System.out.println("   <mod>:  modified file, OR");
   System.out.println("Syntax: TeXFilter <del> <base> <mod>");
   System.out.println("   <del>:  line delimiter string");
   System.out.println("   <base>: file to modify");
   System.out.println("   <mod>:  modified file");
  }
 }
}
