; RLispMaths.lisp (RMCG20030716)

(cond ((eq? 'define define) (load RLisp.lisp)) (t))
(cond ((eq? 'int int) (load RLispJava.lisp)) (t))

(define (# x)
 (new 'java.math.BigInteger (method x toString)))

(define (++ x y) (method (# x) add (# y)))
(define (- x y) (method (# x) subtract (# y)))
(define (** x y) (method (# x) multiply (# y)))
(define (/ x y) (method (# x) divide (# y)))
(define (% x y) (method (# x) remainder (# y)))
(define (> x y)
 (eq? (int 1) (method (# x) compareTo (# y))))
(define (= x y) (eq? (# x) (# y)))

(define (sigma l)
 (cond ((eq? l nil) (# 0))
  (t (++ (car l) (sigma (cdr l))))))
(define + (lambda l (sigma l)))

(define (pi l)
 (cond ((eq? l nil) (# 1))
  (t (** (car l) (pi (cdr l))))))
(define (* , l) (pi l))
