/** \class "RLispInterpreter"

 A Lisp interpreter.

 It uses \See"RLispInterpreter#ENV" as global environment,
 and an \See"RLisp" evaluator \See"RLispInterpreter#lisp".

 @author  Ramn Casares 2003
 @version 2003.03.03
*/
package RLisp;

public class RLispInterpreter {

 /**\variable"ENV"*/
 public REnvironment ENV;

 /**\variable"lisp"*/
 private RLisp lisp;

 /**\method"counter(int)"*/
 public int counter(int val) {
  int i = lisp.counter;
  lisp.counter = val;
  return(i);
 }
 public int counter() { return(lisp.counter); }

 /**\constructor"RLispInterpreter(RLisp)"*/
 public RLispInterpreter(RLisp lisp) {
  RFrame FR = new RFrame();
  ENV = new REnvironment(FR);
  this.lisp = lisp;
 }

 /**\method"Eval(String)"*/
 public Object Eval(String input) {
  Object[] exp = RPair.Tokenize(input);
  if (exp == null) return(null);
  Object res = null;
  for(int i=0; i<exp.length; i++) res = lisp.eval(exp[i],ENV);
  return(res);
 }

 /**\method"eval(String)"*/
 public Object eval(String input) {
  return( lisp.eval(RPair.tokenize(input), ENV) );
 }

 /**\method"toString()"*/
 public String toString() {
  return(lisp.toString() + " on " + ENV.toString(false));
 }

 /** \method "main(String[])"

 Interpretes the arguments as a list sequence.

 Example:
 {\par\tentt\parskip=0pt\baselineskip=12pt
 \par << java RLisp/RLispInterpreter (load RLisp/Primes.lisp)
      (divisors 1222)
 \par >> (2 13 47)
 }

 @param args the command line arguments
 */
 public static void main(String[] args) {
  if ( args.length > 0 ) {
   String s = "";
   for(int i=0; i<args.length; i++) s = s + " " + args[i];
   s = s.substring(1);
   java.net.URL[] urls = new java.net.URL[1];
   java.io.File ud = new java.io.File(System.getProperty("user.dir"));
   try { urls[0] = ud.toURL(); }
   catch (java.net.MalformedURLException mue) {} // always right
   RClassLoader rcl = new RClassLoader(urls);
   RLispInterpreter rli = new RLispInterpreter( new RLispJava(rcl) );
   System.out.println( rli.Eval(s) );
  } else System.out.println( "[null]" );
 }

}
