; RLispArray.lisp (RMCG20040131)

(cond ((eq? 'define define) (load RLisp.lisp)) (t))
(cond ((eq? 'int int) (load RLispJava.lisp)) (t))

(define (isArray? o) (method (method o 'getClass) 'isArray))

; (new Class[] dim1 dim2) creates a bidimensional array sized dim1 x dim2
; (array Class ob1 ob2) creates an array of length 2 initialized

(define (array-length a)
 (method 'java.lang.reflect.Array 'getLength (cons 'java.lang.Object a)))

(define (array-get a i)
 (method 'java.lang.reflect.Array 'get
  (cons 'java.lang.Object a) (cons 'int i)
))

(define (array-set! a i v)
 (method 'java.lang.reflect.Array 'set
  (cons 'java.lang.Object a) (cons 'int i) (cons 'java.lang.Object v)
))

(define (l2v l) ; creates a vector and adds objects in list l to it
 (l2vv l (new 'java.util.Vector)))

(define (l2vv l v) ; adds objects in list l to Vector v
 (cond
  ((eq? l nil) v)
  (t
   (method v 'add (cons 'java.lang.Object (car l)))
   (l2vv (cdr l) v)
)))
