; RLisp.lisp

(def nil (cons))
(def t (eq? (cons) (cons)))
(def null? (lambda (x) (eq? x nil)))
(def not (lambda (b) (cond (b nil) (t t))))
(def list (lambda l l))
(def cadr (lambda (l) (car (cdr l))))

(def macro
 (rho macro
  (lambda ((macro name expander))
   (list 'def name (list 'rho name expander))
)))

(def syntax
 (rho syntax
  (lambda ((syntax template expansion))
   (list 'def (car template)
    (list 'rho (car template)
     (list 'lambda (list template) expansion)
)))))

(syntax (define name definition)
 (cond
  ((atom? name) (list 'def name definition))
  (t (list 'define (car name) (list 'lambda (cdr name) definition)))
))

(syntax (if test t-clause f-clause)
 (list 'cond (list test t-clause) (list 't f-clause)))

(syntax (sequence , expressions)
 (list 'cond (cons 't expressions)))

; (or b1 b2 ...) =>  (cond (b1 t) (t (or b2 ...)))
(syntax (or , terms)
 (cond ((eq? terms nil) 'nil)
  (t (list 'cond (list (car terms) 't) (list 't (cons 'or (cdr terms)))))
))

; (and b1 b2 ...) => (cond (b1 (and b2 ...) (t nil))) =>
(syntax (and , terms)
 (cond ((eq? terms nil) 't)
  (t (list 'cond (list (car terms) (cons 'and (cdr terms))) (list 't 'nil)))
))

(define (mapcar f l)
 (cond ((eq? l nil) nil)
  (t (cons (f (car l)) (mapcar f (cdr l))))
))

; (let ((f1 v1) (f2 v2)) body) => ((lambda (f1 f2) boby) v1 v2)
(syntax (let arglist , body)
 (cons
  (cons 'lambda (cons (mapcar car arglist) body))
  (mapcar cadr arglist)
))

(def GENV (car (cdr (lambda))))
(syntax (Gdefine name definition)
 (list 'eval (list 'def name definition) 'GENV))

(load RLispJava.lisp)
(load RLispArray.lisp)
(load RLispMaths.lisp)
