/** \class "RFrame"

 Implements a frame.

 A frame is a diccionary, that is, is a list of key-value pairs,
 and a pair is a list with two items.

 Following ``Structure and Interpretation of Computer Programs'',
 page 308.

@author  Ramn Casares 2003
@version 2003.03.02
*/
package RLisp;

import java.util.Hashtable;
import java.util.Enumeration;

public class RFrame {

 private Hashtable ht;

 /**\constructor"RFrame()" */
 public RFrame() { ht = new Hashtable(); }

 /**\constructor"RFrame(Object, Object)" */
 public RFrame(Object keys, Object values) {
  ht = new Hashtable(); bind(keys,values);
 }

 /**\method"bind(Object, Object)" */
 public Object bind(Object key, Object value) {
  if ( key == null ) return(null);
  else if ( RPair.isRPair(key) ) {
   if ( RPair.isRPair(value) ) {
    bind(((RPair)key).car(),((RPair)value).car());
    bind(((RPair)key).cdr(),((RPair)value).Cdr()); // note: Cdr
   } else return(null);
  } else { if ( value != null) ht.put(key,value); else ht.remove(key); }
  return(lookup(key));
 }

 /**\method"lookup(Object)" */
 public Object lookup(Object key) {
  if ( key == null ) return(null); else return(ht.get(key));
 }

 /**\method"keys()" */
 public Object[] keys() {
  Object[] ka = new Object[ ht.size() ];
  Enumeration ke = ht.keys();
  int i = 0;
  while ( ke.hasMoreElements() ) ka[i++] = ke.nextElement();
  return( ka );
 }

 private boolean loop = false;

 /**\method"toString()"*/
 public String toString() {
  if ( loop ) return( "RFrame"+hashCode() );
  else {
   loop = true;
   String sr = ht.toString();
   loop = false;
   return(sr);
  }
 }

}
