/** \class "RExtFilter"

Filters files having the extension defined when building the object.

It can be used
 as a "javax.swing.filechooser.FileFilter" for a "JFileChooser", and also
 as a "FilenameFilter" or "java.io.FileFilter" for "File.list(filter)" method.

@author  Ramn Casares 2001
@version 2001.08.29
*/
package RLisp;

import java.io.File;
import java.io.FilenameFilter;

public class RExtFilter extends javax.swing.filechooser.FileFilter
 implements FilenameFilter, java.io.FileFilter {

 /** \variable"ext" contains the extension */
 String ext;

 /**\constructor"RExtFilter(String)"

 @param ext is the extension, starting with a dot
 */
 public RExtFilter(String ext) { this.ext = ext; }


 /**\method"accept(File, String)"

 Tests if the specified file should be included in a file list.
 Implements the "FilenameFilter" interface.

 @param dir the directory in which the file was found
 @param name the name of the file
 @return true if and only if the name should be included in the file list;
  false otherwise
 */
 public boolean accept(File dir, String name) {
  String ext = "";
  if ( name.lastIndexOf('.') > 0 )
   ext = name.substring( name.lastIndexOf('.') );
  return ( this.ext.equals(ext) );
 }

 /**\method"accept(File)"

 Tests if the specified file should shown by a file chooser.
 Implements the "FileFilter" interface.
 Overrides the "FileFilter" class method "accept(File)".

 @param file is the file to show, or not to show
 @return true if and only if the file should be shown, false otherwise
 */
 public boolean accept(File file) {
  if ( file.isFile() ) {
   String name = file.getPath();
   String ext = "";
   if ( name.lastIndexOf('.') > 0 )
    ext = name.substring( name.lastIndexOf('.') );
   return ( this.ext.equals(ext) );
  } else return(true);
 }

 /**\method"getDescrition()"

 Overrides the "FileFilter" class method "getDescription()".

 @return a readable description of the filter
 */
 public String getDescription() {
  if ( ext.length() > 1 )
   return( ext.substring(1) + " files" );
  else return("ERROR: Extension not yet defined!");
 }

}
