/** \class "REnvironment"

 Implements an environment.

 An environment is a list of frames.
 Each frame is a diccionary, that is, is a list of key-value pairs,
 and a pair is a list with two items.

 Following ``Structure and Interpretation of Computer Programs'',
 page 306.

@author  Ramn Casares 2003
@version 2003.03.02
*/
package RLisp;

public class REnvironment extends RPair {

 /**\constructor"REnvironment()"*/
 public REnvironment() { super(); }

 /**\constructor"REnvironment(RFrame)"*/
 public REnvironment(RFrame rf) { super(rf,null); }

 /**\constructor"REnvironment(RFrame, REnvironment)"*/
 public REnvironment(RFrame rf, REnvironment re) { super(rf,re); }

 /**\method"extend(RFrame)"*/
 public REnvironment extend(RFrame rf) {
  return(new REnvironment(rf,this));
 }

 /**\method"firstFrame()"*/
 public RFrame firstFrame() { return( (RFrame)car() ); }
 /**\method"restFrames()"*/
 public REnvironment restFrames() { return( (REnvironment)cdr() ); }

 /**\method"lookup(Object)"*/
 public Object lookup(Object key) {
  if ( this.isNil() ) return(null);
  Object val = firstFrame().lookup(key);
  if ( val != null ) return(val);
  else {
   REnvironment rest = restFrames();
   if ( rest == null ) return(null);
   else return( rest.lookup(key) );
  }
 }

 /**\method"define(Object, Object)"*/
 public Object define(Object key, Object value) {
  if ( this.isNil() ) return(null);
  else {
   firstFrame().bind(key,value);
   return(key);
  }
 }

 /**\method"set(Object, Object)"*/
 public Object set(Object key, Object value) {
  if ( this.isNil() ) return(null);
  else {
   RFrame f = firstFrame();
   Object val = f.lookup(key);
   if ( val != null ) { f.bind(key,value); return(value); }
   else if ( restFrames() == null ) { return(null); }
   else return( restFrames().set(key,value) );
  }
 }


 private boolean loop = false;

 /**\method"toString(boolean)"*/
 public String toString(boolean all) {
  if (all) return( toString() );
  else return("ENV"+hashCode()); }

 /**\method"toString()"*/
 public String toString() {
  REnvironment rest = restFrames();
  if ( rest == null ) { return("GlobalENV"); }
  else if (loop) { return("ENV"+ hashCode()); }
  else {
   loop = true;
   String s = "(ENV"+ hashCode() + ": " + firstFrame().toString() +
               "->" + rest.toString() + ")";
   loop = false;
   return(s);
  }
 }

 /**\method"list()"*/
 public String[] list() {
  RFrame first = firstFrame();
  if (first == null) return(null);
  Object[] ka = first.keys();
  int l = ka.length;
  String[] sa = new String[ l ];
  for(int i=0; i<l; i++)
   sa[i] = ka[i].toString() + "=" + first.lookup(ka[i]).toString();
  return(sa);
 }


 /**\method"keys()"*/
 public Object[] keys() {
  RFrame first = firstFrame();
  if (first == null) return(null); else return(first.keys());
 }

 /**\method"keys(Class, boolean)"*/
 public Object[] keys(Class c, boolean strict) {
  RFrame first = firstFrame();
  if (first == null || c == null) return(null);
  else if ( c == Boolean.TYPE ) c = Boolean.class;
  else if ( c == Character.TYPE ) c = Character.class;
  else if ( c == Byte.TYPE ) c = Byte.class;
  else if ( c == Short.TYPE ) c = Short.class;
  else if ( c == Integer.TYPE ) c = Integer.class;
  else if ( c == Long.TYPE ) c = Long.class;
  else if ( c == Float.TYPE ) c = Float.class;
  else if ( c == Double.TYPE ) c = Double.class;
  Object[] names = first.keys();
  java.util.Vector sel = new java.util.Vector();
  Object n; Object o;
  for(int i=0; i<names.length; i++) {
   n = names[i];
   o = first.lookup(n);
   if (strict) { if ( o.getClass() == c) sel.addElement(n); }
   else        { if ( c.isInstance(o) )  sel.addElement(n); }
  }
  return(sel.toArray());
 }


}
