/** \class "RClassLoader"

Class "RClassLoader" extends "URLClassLoader" making method
"addURL(URL)" "public", and so "RClassLoader" is an incremental
"ClassLoader".

@author  Ramn Casares 2003
@version 2003.03.22
*/
package RLisp;

import java.net.URL;
import java.net.URLClassLoader;

public class RClassLoader extends URLClassLoader {

 /**\constructor"RClassLoader(URL[])" */
 public RClassLoader(URL[] urls) { super(urls); }

 /**\method"addURL(URL)"

 Makes "public" the "protected" "super.addURL(URL)" method.

 It first checks if the "url" has been already loaded, because the
 "super" method doesn't.

 @param url is the "URL" incremented
 */
 public void addURL(URL url) {
  if ( url == null ) return;
  URL[] urls = this.getURLs();
  boolean isNew = true;
  for (int i=0; i<urls.length; i++) isNew = isNew && !url.equals(urls[i]);
  if ( isNew ) super.addURL(url);
 }

}
