; Primes.lisp (RMCG20030716)

(cond ((eq? 'define define) (load RLisp.lisp)) (t))
(cond ((eq? '* *) (load RLispMaths.lisp)) (t))

(define (divides? a b) (= (% b a) 0))
(define (square x) (* x x))
(define (find-divisor n test-divisor)
 (cond
  ((> (square test-divisor) n) n)
  ((divides? test-divisor n) test-divisor)
  (t (find-divisor n (+ test-divisor 1)))))
(define (smallest-divisor n) (find-divisor n 2))
(define (prime? n) (= n (smallest-divisor n)))
(define (divisors x)
 (cond
  ((prime? x) (cons x nil))
  (t (cons (smallest-divisor x) (divisors (/ x (smallest-divisor x)))))))
